@extends('dashboard.layouts.app')
@section('css')
    <script src="{{ asset('js/tree-view.js') }}"></script>
    <style>
        ul.treeview {
            text-transform: uppercase;
        }
    </style>
    <link rel="stylesheet" href="{{ asset('css/tree-view.css') }}">
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Users</h5>
            {{-- <div class="custom-breadcrumb ml-auto">
          <a href="{{url('/dashboard')}}" class="breadcrumb">Home</a>
          <a href="{{url('/dashboard/users')}}" class="breadcrumb">Users</a>
      </div> --}}
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l9">
                <div class="card">
                    <div class="card-content">
                        @if (\Auth::user()->checkPermission('create-user'))
                            <h5 class="card-title activator">
                                <h5 class="card-title activator"><a class="waves-effect waves-light btn"
                                        href="{{ url('/dashboard/users/create') }}">Add User</a></h5>
                            </h5>
                        @endif



                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif
                        <table id="zero_config" class="responsive-table display" style="width:100%">
                            <thead>
                                <tr>

                                    <th>
                                        Name
                                    </th>
                                    <th>
                                        Email ID
                                    </th>
                                    <th>
                            Branch
                        </th>
                                    <th>
                                        Role
                                    </th>
                                    <th>
                                        Report To
                                    </th>
                                    <th>
                                        Status
                                    </th>
                                    <th>
                                        Image
                                    </th>
                                    @if (auth()->user()->checkPermission('edit-user'))
                                        <th></th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @if (count($users) > 0)
                                    @php
                                        $i = 1;
                                    @endphp
                                    @foreach ($users as $row)
                                        <tr id="user_{{ $row->id }}">

                                            <td>
                                                <a>
                                                    {{ $row->name }}
                                                </a>
                                                <br />
                                                <small>
                                                    Created {{ $row->created_at }}
                                                </small>
                                            </td>
                                            <td>
                                                {{ $row->email }}
                                            </td>
                                            <td>
                            {{ $row->getBranch ? $row->getBranch->name : ''}}
                         </td>
                                            <td>
                                                @php
                                                    $r = [];
                                                @endphp
                                                @if (isset($row->roles))
                                                    @foreach ($row->roles as $role)
                                                        @php $r[] = $role->name;@endphp
                                                    @endforeach
                                                @endif
                                                @php echo join(',',$r);@endphp
                                            </td>
                                            <td>
                                                {{ isset($row->getReportingTo) ? $row->getReportingTo->name : '' }}
                                            </td>

                                            <td class="project-state">
                                                <span class="badge">{{ $row->status == 1 ? 'Active' : 'Inactive' }}</span>
                                            </td>
                                            <td>
                                                @if (!empty($row->image))
                                                    <img src="{{ asset('uploads/' . $row->image) }}" width="50"
                                                        height="50">
                                                @endif
                                            </td>


                                            @if (auth()->user()->checkPermission('edit-user'))
                                                <td class="project-actions text-right">

                                                    <a class="btn btn-info btn-sm"
                                                        href="{{ url('/dashboard/users/edit/' . $row->id) }}"
                                                        @if ($row->hasRole('super-admin')) disabled @endif>
                                                        <i class="fas fa-pencil-alt">
                                                        </i>

                                                    </a>

                                                </td>
                                            @endif
                                        </tr>
                                        @php
                                            $i++;
                                        @endphp
                                    @endforeach
                                @endif

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col l3 s3">

                <div class="row">
                    <div class="col l12">

                        <ul data-role="treeview">
                            @foreach ($users_mgt_role as $u)
                                @php
                                    $user_id = $u->id;
                                    //$role_id = $u->role_id;
                                @endphp
                                <li><?php echo $u->name;
                                echo get($user_id);
                                ?></li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <?php
function get($user_id,$depth=0){
    $usr = \App\User::find($user_id);
    $get_role = \DB::table('users_roles')->join('roles','users_roles.role_id','=','roles.id')->where('users_roles.user_id',$user_id)->select('users_roles.role_id')->first();
   if($get_role){
    $role_id = $get_role->role_id;
}
    $depth = $depth+10;
        $reporting_tos = $usr->reportingUsers();
        ?>
                {{-- <li>{{$usr->name}} --}}
                @if (isset($reporting_tos))
                    <ul style="padding-left:<?php echo $depth . 'px'; ?>">
                        <?php foreach($reporting_tos as $r){?>
                        <li><?php echo $r->name; ?>

                            <?php echo get($r->id, $depth); ?>

                        </li>
                        <?php
                }?>
                    </ul>
                @endif
                {{-- </li> --}}
                <?php
}
?>

            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('js/tree-view.js') }}"></script>
@endsection
